/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    class ArmorDyeRecipe extends Internal.CustomRecipe {
        constructor($$0: ResourceLocation_, $$1: Internal.CraftingBookCategory_)
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        matches($$0: Internal.CraftingContainer_, $$1: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getRemainingItems($$0: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getType(): ResourceLocation;
        assemble($$0: Internal.CraftingContainer_, $$1: Internal.RegistryAccess_): Internal.ItemStack;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getMod(): string;
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get mod(): string
    }
    type ArmorDyeRecipe_ = ArmorDyeRecipe;
    class GeodeConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: Internal.GeodeBlockSettings_, $$1: Internal.GeodeLayerSettings_, $$2: Internal.GeodeCrackSettings_, $$3: number, $$4: number, $$5: boolean, $$6: Internal.IntProvider_, $$7: Internal.IntProvider_, $$8: Internal.IntProvider_, $$9: number, $$10: number, $$11: number, $$12: number)
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.GeodeConfiguration>;
        readonly placementsRequireLayer0Alternate: boolean;
        readonly geodeLayerSettings: Internal.GeodeLayerSettings;
        readonly minGenOffset: number;
        readonly geodeBlockSettings: Internal.GeodeBlockSettings;
        readonly usePotentialPlacementsChance: number;
        readonly distributionPoints: Internal.IntProvider;
        readonly maxGenOffset: number;
        static readonly CHANCE_RANGE: Internal.Codec<number>;
        readonly noiseMultiplier: number;
        readonly useAlternateLayer0Chance: number;
        readonly geodeCrackSettings: Internal.GeodeCrackSettings;
        readonly outerWallDistance: Internal.IntProvider;
        readonly pointOffset: Internal.IntProvider;
        readonly invalidBlocksThreshold: number;
    }
    type GeodeConfiguration_ = GeodeConfiguration;
    interface ILimitedGlobalStation extends Internal.ILimited {
        abstract getDisablingTrain(): Internal.Train;
        abstract isStationEnabled(): boolean;
        abstract isLimitEnabled(): boolean;
        abstract orDisablingTrain(arg0: Internal.Train_, arg1: Internal.Train_): Internal.Train;
        abstract setLimitEnabled(arg0: boolean): void;
        makeLimitEnabledPacket(pos: BlockPos_, limitEnabled: boolean): Internal.StationEditPacket;
        get disablingTrain(): Internal.Train
        get stationEnabled(): boolean
        get limitEnabled(): boolean
        set limitEnabled(arg0: boolean)
    }
    type ILimitedGlobalStation_ = ILimitedGlobalStation;
    class TripWireHookBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        calculateState($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean, $$4: boolean, $$5: number, $$6: Internal.BlockState_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly ATTACHED: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
        static readonly POWERED: Internal.BooleanProperty;
    }
    type TripWireHookBlock_ = TripWireHookBlock;
    interface BlockKJS extends Internal.BlockBuilderProvider {
        setExplosionResistance(v: number): void;
        setDestroySpeed(v: number): void;
        setIsRandomlyTicking(v: boolean): void;
        setRandomTickCallback(callback: Internal.Consumer_<Internal.RandomTickCallbackJS>): void;
        setFriction(v: number): void;
        getTypeData(): Internal.CompoundTag;
        getId(): string;
        setBlockBuilder(b: Internal.BlockBuilder_): void;
        setNameKey(key: string): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        setRequiresTool(v: boolean): void;
        setSpeedFactor(v: number): void;
        setSoundType(v: SoundType_): void;
        setHasCollision(v: boolean): void;
        setLightEmission(v: number): void;
        getBlockBuilder(): Internal.BlockBuilder;
        getIdLocation(): ResourceLocation;
        setJumpFactor(v: number): void;
        getMod(): string;
        set explosionResistance(v: number)
        set destroySpeed(v: number)
        set isRandomlyTicking(v: boolean)
        set randomTickCallback(callback: Internal.Consumer_<Internal.RandomTickCallbackJS>)
        set friction(v: number)
        get typeData(): Internal.CompoundTag
        get id(): string
        set blockBuilder(b: Internal.BlockBuilder_)
        set nameKey(key: string)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set speedFactor(v: number)
        set soundType(v: SoundType_)
        set hasCollision(v: boolean)
        set lightEmission(v: number)
        get blockBuilder(): Internal.BlockBuilder
        get idLocation(): ResourceLocation
        set jumpFactor(v: number)
        get mod(): string
    }
    type BlockKJS_ = BlockKJS;
    class SnowLayerBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly MAX_HEIGHT: 8;
        static readonly LAYERS: Internal.IntegerProperty;
        static readonly HEIGHT_IMPASSABLE: 5;
    }
    type SnowLayerBlock_ = SnowLayerBlock;
    class ComponentWrapper {
        static translate(key: Special.LangKey, ...objects: any[]): Internal.MutableComponent;
        static translate(key: Special.LangKey): Internal.MutableComponent;
    }
    type ComponentWrapper_ = ComponentWrapper;
    class BlockEntityRendererProvider$Context {
        constructor($$0: Internal.BlockEntityRenderDispatcher_, $$1: Internal.BlockRenderDispatcher_, $$2: Internal.ItemRenderer_, $$3: Internal.EntityRenderDispatcher_, $$4: Internal.EntityModelSet_, $$5: net.minecraft.client.gui.Font_)
        getFont(): net.minecraft.client.gui.Font;
        getItemRenderer(): Internal.ItemRenderer;
        getModelSet(): Internal.EntityModelSet;
        getEntityRenderer(): Internal.EntityRenderDispatcher;
        getBlockRenderDispatcher(): Internal.BlockRenderDispatcher;
        getBlockEntityRenderDispatcher(): Internal.BlockEntityRenderDispatcher;
        bakeLayer($$0: Internal.ModelLayerLocation_): Internal.ModelPart;
        get font(): net.minecraft.client.gui.Font
        get itemRenderer(): Internal.ItemRenderer
        get modelSet(): Internal.EntityModelSet
        get entityRenderer(): Internal.EntityRenderDispatcher
        get blockRenderDispatcher(): Internal.BlockRenderDispatcher
        get blockEntityRenderDispatcher(): Internal.BlockEntityRenderDispatcher
    }
    type BlockEntityRendererProvider$Context_ = BlockEntityRendererProvider$Context;
    class PlacementOptions extends Internal.Enum<Internal.PlacementOptions> {
        static valueOf(name: string): Internal.PlacementOptions;
        static values(): Internal.PlacementOptions[];
        static readonly Merged: Internal.PlacementOptions;
        static readonly Attached: Internal.PlacementOptions;
        translationKey: string;
        static readonly Inserted: Internal.PlacementOptions;
        icon: Internal.AllIcons;
    }
    type PlacementOptions_ = PlacementOptions | "attached" | "merged" | "inserted";
    interface CreativeTabIconSupplier {
        abstract getIcon(): Internal.ItemStack;
        get icon(): Internal.ItemStack
        (): Internal.ItemStack_;
        readonly DEFAULT: Internal.CreativeTabIconSupplier;
    }
    type CreativeTabIconSupplier_ = CreativeTabIconSupplier;
    interface DensityFunction$Visitor {
        abstract apply(arg0: Internal.DensityFunction_): Internal.DensityFunction;
        visitNoise($$0: Internal.DensityFunction$NoiseHolder_): Internal.DensityFunction$NoiseHolder;
        (arg0: Internal.DensityFunction): Internal.DensityFunction_;
    }
    type DensityFunction$Visitor_ = DensityFunction$Visitor;
    interface RenderStateShardAccessor {
        abstract port_lib$setupState(arg0: Internal.Runnable_): void;
        abstract port_lib$clearState(arg0: Internal.Runnable_): void;
    }
    type RenderStateShardAccessor_ = RenderStateShardAccessor;
    class ClientboundKeepAlivePacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getId(): number;
        isSkippable(): boolean;
        get id(): number
        get skippable(): boolean
    }
    type ClientboundKeepAlivePacket_ = ClientboundKeepAlivePacket;
    class BaseComfortsItem extends Internal.BlockItem {
        constructor(block: Internal.Block_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BaseComfortsItem_ = BaseComfortsItem;
    class DeadCoralClawFeature extends Internal.CoralClawFeature {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type DeadCoralClawFeature_ = DeadCoralClawFeature;
    class ClientboundSetEquipmentPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: number, $$1: Internal.List_<com.mojang.datafixers.util.Pair<Internal.EquipmentSlot, Internal.ItemStack>>)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getEntity(): number;
        getSlots(): Internal.List<com.mojang.datafixers.util.Pair<Internal.EquipmentSlot, Internal.ItemStack>>;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get entity(): number
        get slots(): Internal.List<com.mojang.datafixers.util.Pair<Internal.EquipmentSlot, Internal.ItemStack>>
        get skippable(): boolean
    }
    type ClientboundSetEquipmentPacket_ = ClientboundSetEquipmentPacket;
    class Abilities {
        constructor()
        addSaveData($$0: Internal.CompoundTag_): void;
        setWalkingSpeed($$0: number): void;
        getFlyingSpeed(): number;
        setFlyingSpeed($$0: number): void;
        getWalkingSpeed(): number;
        loadSaveData($$0: Internal.CompoundTag_): void;
        set walkingSpeed($$0: number)
        get flyingSpeed(): number
        set flyingSpeed($$0: number)
        get walkingSpeed(): number
        instabuild: boolean;
        flying: boolean;
        invulnerable: boolean;
        mayfly: boolean;
        mayBuild: boolean;
    }
    type Abilities_ = Abilities;
    class CraftingJobStatus extends Internal.Record {
        constructor(crafting: Internal.GenericStack_, totalItems: number, progress: number, elapsedTimeNanos: number)
        progress(): number;
        elapsedTimeNanos(): number;
        crafting(): Internal.GenericStack;
        totalItems(): number;
    }
    type CraftingJobStatus_ = CraftingJobStatus;
    interface AbstractWidgetAccessor {
        abstract port_lib$setHeight(arg0: number): void;
        (arg0: number): void;
    }
    type AbstractWidgetAccessor_ = AbstractWidgetAccessor;
    class ThresholdSwitchBlockEntity extends Internal.SmartBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isInverted(): boolean;
        updateCurrentLevel(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        format(value: number, stacks: boolean): Internal.MutableComponent;
        shouldBePowered(): boolean;
        setInverted(inverted: boolean): void;
        onLoad(): void;
        updatePowerAfterDelay(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getDisplayItemForScreen(): Internal.ItemStack;
        isPowered(): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getStockLevel(): number;
        invalidateCaps(): void;
        getMaxLevel(): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        getMinLevel(): number;
        asComponentProvider(): Internal.ComponentProvider;
        getLevelForDisplay(): number;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        getTypeOfCurrentTarget(): Internal.ThresholdSwitchBlockEntity$ThresholdType;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getState(): boolean;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get inverted(): boolean
        set inverted(inverted: boolean)
        get displayItemForScreen(): Internal.ItemStack
        get powered(): boolean
        get stockLevel(): number
        get maxLevel(): number
        get minLevel(): number
        get levelForDisplay(): number
        get infiniteBoundingBox(): Internal.AABB
        get typeOfCurrentTarget(): Internal.ThresholdSwitchBlockEntity$ThresholdType
        get state(): boolean
        currentLevel: number;
        currentMinLevel: number;
        onWhenAbove: number;
        inStacks: boolean;
        offWhenBelow: number;
        currentMaxLevel: number;
    }
    type ThresholdSwitchBlockEntity_ = ThresholdSwitchBlockEntity;
    interface WrappedJS {
    }
    type WrappedJS_ = WrappedJS;
    interface RegistrateProvider extends Internal.DataProvider {
        abstract run(arg0: Internal.CachedOutput_): Internal.CompletableFuture<any>;
        abstract getName(): string;
        abstract getSide(): Internal.EnvType;
        saveStable($$0: Internal.CachedOutput_, $$1: Internal.JsonElement_, $$2: Internal.Path_): Internal.CompletableFuture<any>;
        get name(): string
        get side(): Internal.EnvType
    }
    type RegistrateProvider_ = RegistrateProvider;
    class StringRange {
        constructor(arg0: number, arg1: number)
        static at(arg0: number): Internal.StringRange;
        getStart(): number;
        getEnd(): number;
        static encompassing(arg0: Internal.StringRange_, arg1: Internal.StringRange_): Internal.StringRange;
        get(arg0: string): string;
        get(arg0: Internal.ImmutableStringReader_): string;
        isEmpty(): boolean;
        getLength(): number;
        static between(arg0: number, arg1: number): Internal.StringRange;
        get start(): number
        get end(): number
        get empty(): boolean
        get length(): number
    }
    type StringRange_ = StringRange;
    interface IEnderExtender {
        abstract getExtendedCapacity(arg0: Internal.ItemStack_): number;
        abstract getExtendedEnergy(arg0: Internal.ItemStack_): number;
    }
    type IEnderExtender_ = IEnderExtender;
    interface SoundEventListener {
        abstract onPlaySound(arg0: Internal.SoundInstance_, arg1: Internal.WeighedSoundEvents_): void;
        (arg0: Internal.SoundInstance, arg1: Internal.WeighedSoundEvents): void;
    }
    type SoundEventListener_ = SoundEventListener;
    class EnvironmentScanPlacement extends Internal.PlacementModifier {
        static scanningFor($$0: Internal.Direction_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$2: number): Internal.EnvironmentScanPlacement;
        static scanningFor($$0: Internal.Direction_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$2: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$3: number): Internal.EnvironmentScanPlacement;
        static readonly CODEC: Internal.Codec<Internal.EnvironmentScanPlacement>;
    }
    type EnvironmentScanPlacement_ = EnvironmentScanPlacement;
    class CuckooClockBlockEntity extends Internal.KineticBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        startAnimation(animation: Internal.CuckooClockBlockEntity$Animation_): void;
        moveHands(hours: number, minutes: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
        minuteHand: Internal.LerpedFloat;
        hourHand: Internal.LerpedFloat;
        animationProgress: Internal.LerpedFloat;
        animationType: Internal.CuckooClockBlockEntity$Animation;
    }
    type CuckooClockBlockEntity_ = CuckooClockBlockEntity;
    class SlidingDoorPartProperty extends Internal.Enum<Internal.SlidingDoorPartProperty> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        isController(): boolean;
        static values(): Internal.SlidingDoorPartProperty[];
        getSerializedName(): string;
        xOffset(): number;
        static valueOf(name: string): Internal.SlidingDoorPartProperty;
        yOffset(): number;
        get controller(): boolean
        get serializedName(): string
        static readonly TOP: Internal.SlidingDoorPartProperty;
        static readonly TOP_RIGHT: Internal.SlidingDoorPartProperty;
        static readonly BOTTOM: Internal.SlidingDoorPartProperty;
        static readonly CENTER: Internal.SlidingDoorPartProperty;
        static readonly TOP_LEFT: Internal.SlidingDoorPartProperty;
        static readonly BOTTOM_RIGHT: Internal.SlidingDoorPartProperty;
        static readonly RIGHT: Internal.SlidingDoorPartProperty;
        static readonly BOTTOM_LEFT: Internal.SlidingDoorPartProperty;
        static readonly LEFT: Internal.SlidingDoorPartProperty;
    }
    type SlidingDoorPartProperty_ = "bottom_right" | "top_left" | "top_right" | "center" | "bottom" | SlidingDoorPartProperty | "top" | "bottom_left" | "right" | "left";
    interface ChannelId extends Internal.Comparable<Internal.ChannelId>, Internal.Serializable {
        abstract compareTo(arg0: Internal.ChannelId_): number;
        abstract asShortText(): string;
        abstract asLongText(): string;
    }
    type ChannelId_ = ChannelId;
    class StringIota extends Internal.Iota {
        static make(string: string): Internal.StringIota;
        static makeUnchecked(string: string): Internal.StringIota;
        getString(): string;
        get string(): string
        static TYPE: Internal.StringIota$1;
    }
    type StringIota_ = StringIota;
    class Donkey extends Internal.AbstractChestedHorse {
        constructor($$0: Internal.EntityType_<Internal.Donkey>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getOwner(): Internal.LivingEntity;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getSaddleSoundEvent(): Internal.SoundEvent;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getJumpCooldown(): number;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get owner(): Internal.LivingEntity
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get saddleSoundEvent(): Internal.SoundEvent
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get jumpCooldown(): number
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Donkey_ = Donkey;
    class SearedDuctBlock extends Internal.InventoryBlock implements Internal.LandPathNodeTypesRegistry$StaticPathNodeTypeProvider {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getPathNodeType(state: Internal.BlockState_, neighbor: boolean): Internal.BlockPathTypes;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly IN_STRUCTURE: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type SearedDuctBlock_ = SearedDuctBlock;
    interface AnimationController$AnimationStateHandler <A extends Internal.GeoAnimatable> {
        abstract handle(arg0: software.bernie.geckolib.core.animation.AnimationState_<A>): Internal.PlayState;
        (arg0: software.bernie.geckolib.core.animation.AnimationState<A>): Internal.PlayState_;
    }
    type AnimationController$AnimationStateHandler_<A extends Internal.GeoAnimatable> = AnimationController$AnimationStateHandler<A>;
    class ClientboundCommandSuggestionsPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: number, $$1: Internal.Suggestions_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        getSuggestions(): Internal.Suggestions;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        getId(): number;
        get suggestions(): Internal.Suggestions
        get skippable(): boolean
        get id(): number
    }
    type ClientboundCommandSuggestionsPacket_ = ClientboundCommandSuggestionsPacket;
    class SkinManager {
        constructor($$0: Internal.TextureManager_, $$1: Internal.File_, $$2: Internal.MinecraftSessionService_)
        getInsecureSkinInformation($$0: Internal.GameProfile_): Internal.Map<Internal.MinecraftProfileTexture$Type, Internal.MinecraftProfileTexture>;
        handler$bjm000$chat_heads$chatheads$rememberTextureLocation(cir: Internal.CallbackInfoReturnable_<any>, id: ResourceLocation_, httpTexture: Internal.HttpTexture_): void;
        registerSkins($$0: Internal.GameProfile_, $$1: Internal.SkinManager$SkinTextureCallback_, $$2: boolean): void;
        registerTexture($$0: Internal.MinecraftProfileTexture_, $$1: Internal.MinecraftProfileTexture$Type_): ResourceLocation;
        getInsecureSkinLocation($$0: Internal.GameProfile_): ResourceLocation;
        readonly textureManager: Internal.TextureManager;
        static readonly PROPERTY_TEXTURES: "textures";
    }
    type SkinManager_ = SkinManager;
    interface FlyingAnimal {
        abstract isFlying(): boolean;
        get flying(): boolean
        (): boolean;
    }
    type FlyingAnimal_ = FlyingAnimal;
    abstract class ListeningBlockStatePredicate extends Internal.TrackedBlockStatePredicate {
        and(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
        static not<T>(arg0: Internal.Predicate_<T>): Internal.Predicate<T>;
        or(arg0: Internal.Predicate_<Internal.BlockState>): Internal.Predicate<Internal.BlockState>;
        negate(): Internal.Predicate<Internal.BlockState>;
        static isEqual<T>(arg0: any): Internal.Predicate<T>;
        static LISTENING_MASK: 1;
    }
    type ListeningBlockStatePredicate_ = ListeningBlockStatePredicate;
    class BlazeBurnerBlockItem extends Internal.BlockItem {
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static empty(properties: Internal.Item$Properties_): Internal.BlazeBurnerBlockItem;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        static withBlaze(block: Internal.Block_, properties: Internal.Item$Properties_): Internal.BlazeBurnerBlockItem;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        hasCapturedBlaze(): boolean;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BlazeBurnerBlockItem_ = BlazeBurnerBlockItem;
    class CreativeFluidTankBlockEntity extends Internal.FluidTankBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getMainAxisOf(be: Internal.BlockEntity_): Internal.Direction$Axis;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getItemStorage(side: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
    }
    type CreativeFluidTankBlockEntity_ = CreativeFluidTankBlockEntity;
    class NoiseChunk implements Internal.DensityFunction$ContextProvider, Internal.DensityFunction$FunctionContext {
        constructor($$0: number, $$1: Internal.RandomState_, $$2: number, $$3: number, $$4: Internal.NoiseSettings_, $$5: Internal.DensityFunctions$BeardifierOrMarker_, $$6: Internal.NoiseGeneratorSettings_, $$7: Internal.Aquifer$FluidPicker_, $$8: Internal.Blender_)
        updateForZ($$0: number, $$1: number): void;
        updateForY($$0: number, $$1: number): void;
        getBlender(): Internal.Blender;
        stopInterpolation(): void;
        static forChunk($$0: Internal.ChunkAccess_, $$1: Internal.RandomState_, $$2: Internal.DensityFunctions$BeardifierOrMarker_, $$3: Internal.NoiseGeneratorSettings_, $$4: Internal.Aquifer$FluidPicker_, $$5: Internal.Blender_): Internal.NoiseChunk;
        selectCellYZ($$0: number, $$1: number): void;
        updateForX($$0: number, $$1: number): void;
        aquifer(): Internal.Aquifer;
        swapSlices(): void;
        forIndex(arg0: number): Internal.DensityFunction$FunctionContext;
        blockX(): number;
        forIndex($$0: number): this;
        initializeForFirstCellX(): void;
        fillAllDirectly($$0: number[], $$1: Internal.DensityFunction_): void;
        advanceCellX($$0: number): void;
        blockZ(): number;
        preliminarySurfaceLevel($$0: number, $$1: number): number;
        blockY(): number;
        get blender(): Internal.Blender
    }
    type NoiseChunk_ = NoiseChunk;
    interface DyeExtension {
        getTag(): Internal.TagKey<Internal.Item>;
        get tag(): Internal.TagKey<Internal.Item>
    }
    type DyeExtension_ = DyeExtension;
    class FluidBuilder extends Internal.BuilderBase<Internal.FlowingFluid> {
        constructor(i: ResourceLocation_)
        bucketColor(c: dev.latvian.mods.rhino.mod.util.color.Color_): this;
        flowingTexture(id: ResourceLocation_): this;
        noBucket(): this;
        luminosity(luminosity: number): this;
        gaseous(): this;
        builtinTextures(): this;
        stillTexture(id: ResourceLocation_): this;
        createObject(): any;
        viscosity(viscosity: number): this;
        displayName(name: net.minecraft.network.chat.Component_): Internal.BuilderBase<Internal.FlowingFluid>;
        createAttributes(): Internal.ArchitecturyFluidAttributes;
        thickTexture(color: dev.latvian.mods.rhino.mod.util.color.Color_): this;
        rarity(rarity: Internal.Rarity_): this;
        tag(tag: ResourceLocation_): Internal.BuilderBase<Internal.FlowingFluid>;
        translucent(): this;
        color(c: dev.latvian.mods.rhino.mod.util.color.Color_): this;
        density(density: number): this;
        noBlock(): this;
        renderType(l: string): this;
        thinTexture(color: dev.latvian.mods.rhino.mod.util.color.Color_): this;
        temperature(temperature: number): this;
        bucketItem: Internal.FluidBucketItemBuilder;
        attributes: Internal.ArchitecturyFluidAttributes;
        flowingFluid: Internal.FlowingFluidBuilder;
        block: Internal.FluidBlockBuilder;
    }
    type FluidBuilder_ = FluidBuilder;
    interface BakedQuadAccess {
        abstract setVertices(arg0: number[]): void;
        set vertices(arg0: number[])
        (arg0: number[]): void;
    }
    type BakedQuadAccess_ = BakedQuadAccess;
    interface ChunkRandomSource {
        abstract getRandomPosInChunk(arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.BlockPos$MutableBlockPos_): void;
        (arg0: number, arg1: number, arg2: number, arg3: number, arg4: Internal.BlockPos$MutableBlockPos): void;
    }
    type ChunkRandomSource_ = ChunkRandomSource;
    class SteamEngineBlock extends Internal.FaceAttachedHorizontalDirectionalBlock implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.SimpleWaterloggedBlock, Internal.IBE<Internal.SteamEngineBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.SteamEngineBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.SteamEngineBlockEntity;
        setRequiresTool(v: boolean): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.SteamEngineBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        static getShaftPos(sideState: Internal.BlockState_, pos: BlockPos_): BlockPos;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.SteamEngineBlockEntity>): void;
        setLightEmission(v: number): void;
        static getSpeedRange(): Internal.Couple<number>;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getBlockEntityClass(): typeof Internal.SteamEngineBlockEntity;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static canAttach(pReader: Internal.LevelReader_, pPos: BlockPos_, pDirection: Internal.Direction_): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.SteamEngineBlockEntity>;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        static isShaftValid(state: Internal.BlockState_, shaft: Internal.BlockState_): boolean;
        static getConnectedDirection(state: Internal.BlockState_): Internal.Direction;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static getFacing(sideState: Internal.BlockState_): Internal.Direction;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get speedRange(): Internal.Couple<number>
        get mod(): string
        get blockEntityClass(): typeof Internal.SteamEngineBlockEntity
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.SteamEngineBlockEntity>
    }
    type SteamEngineBlock_ = SteamEngineBlock;
    class SculkSensorPhase extends Internal.Enum<Internal.SculkSensorPhase> implements Internal.StringRepresentable {
        static values(): Internal.SculkSensorPhase[];
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf($$0: string): Internal.SculkSensorPhase;
        getSerializedName(): string;
        get serializedName(): string
        static readonly ACTIVE: Internal.SculkSensorPhase;
        static readonly COOLDOWN: Internal.SculkSensorPhase;
        static readonly INACTIVE: Internal.SculkSensorPhase;
    }
    type SculkSensorPhase_ = "inactive" | "active" | SculkSensorPhase | "cooldown";
    class RollerBlockItem extends Internal.BlockItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type RollerBlockItem_ = RollerBlockItem;
    interface AttributedCharacterIterator extends Internal.CharacterIterator {
        abstract clone(): any;
        abstract getRunStart(arg0: Internal.AttributedCharacterIterator$Attribute_): number;
        abstract getRunLimit(): number;
        abstract getAttribute(arg0: Internal.AttributedCharacterIterator$Attribute_): any;
        abstract getIndex(): number;
        abstract setIndex(arg0: number): string;
        abstract getRunLimit(arg0: Internal.Set_<Internal.AttributedCharacterIterator$Attribute>): number;
        abstract next(): string;
        abstract current(): string;
        abstract last(): string;
        abstract first(): string;
        abstract getAttributes(): Internal.Map<Internal.AttributedCharacterIterator$Attribute, any>;
        abstract getRunStart(arg0: Internal.Set_<Internal.AttributedCharacterIterator$Attribute>): number;
        abstract previous(): string;
        abstract getBeginIndex(): number;
        abstract getAllAttributeKeys(): Internal.Set<Internal.AttributedCharacterIterator$Attribute>;
        abstract getRunLimit(arg0: Internal.AttributedCharacterIterator$Attribute_): number;
        abstract getRunStart(): number;
        abstract getEndIndex(): number;
        get runLimit(): number
        get index(): number
        set index(arg0: number)
        get attributes(): Internal.Map<Internal.AttributedCharacterIterator$Attribute, any>
        get beginIndex(): number
        get allAttributeKeys(): Internal.Set<Internal.AttributedCharacterIterator$Attribute>
        get runStart(): number
        get endIndex(): number
    }
    type AttributedCharacterIterator_ = AttributedCharacterIterator;
    interface IToolStat <T> {
        formatColoredMultiplier(loc: string, number: number): net.minecraft.network.chat.Component;
        clamp(value: T): T;
        abstract write(arg0: T): Internal.Tag;
        getPrefix(): Internal.MutableComponent;
        abstract read(arg0: Internal.Tag_): T;
        getDescription(): Internal.MutableComponent;
        formatColoredBonus(loc: string, number: number, scale: number): net.minecraft.network.chat.Component;
        abstract deserialize(arg0: Internal.JsonElement_): T;
        abstract build(arg0: any, arg1: T): T;
        formatNumber(loc: string, color: Internal.TextColor_, number: number): net.minecraft.network.chat.Component;
        abstract getDefaultValue(): T;
        abstract fromNetwork(arg0: Internal.FriendlyByteBuf_): T;
        formatNumberPercent(loc: string, color: Internal.TextColor_, number: number): net.minecraft.network.chat.Component;
        abstract getName(): Internal.ToolStatId;
        abstract makeBuilder(): any;
        abstract formatValue(arg0: T): net.minecraft.network.chat.Component;
        abstract update(arg0: Internal.ModifierStatsBuilder_, arg1: T): void;
        supports(item: Internal.Item_): boolean;
        abstract serialize(arg0: T): Internal.JsonElement;
        abstract toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: T): void;
        formatNumber(loc: string, color: Internal.TextColor_, number: number): net.minecraft.network.chat.Component;
        get prefix(): Internal.MutableComponent
        get description(): Internal.MutableComponent
        get defaultValue(): T
        get name(): Internal.ToolStatId
    }
    type IToolStat_<T> = IToolStat<T>;
    interface BlockColorsExtended {
        getProviders(blockColors: Internal.BlockColors_): Internal.Reference2ReferenceMap<Internal.Block, Internal.BlockColor>;
        getOverridenVanillaBlocks(blockColors: Internal.BlockColors_): Internal.ReferenceSet<Internal.Block>;
        abstract sodium$getProviders(): Internal.Reference2ReferenceMap<Internal.Block, Internal.BlockColor>;
        abstract sodium$getOverridenVanillaBlocks(): Internal.ReferenceSet<Internal.Block>;
    }
    type BlockColorsExtended_ = BlockColorsExtended;
    interface ObjectInput extends Internal.AutoCloseable, Internal.DataInput {
        abstract readByte(): number;
        abstract readFully(arg0: number[], arg1: number, arg2: number): void;
        abstract readUnsignedByte(): number;
        abstract readUnsignedShort(): number;
        abstract readLong(): number;
        abstract read(arg0: number[], arg1: number, arg2: number): number;
        abstract read(): number;
        abstract readFully(arg0: number[]): void;
        abstract readDouble(): number;
        abstract readObject(): any;
        abstract skip(arg0: number): number;
        abstract readInt(): number;
        abstract readFloat(): number;
        abstract readBoolean(): boolean;
        abstract skipBytes(arg0: number): number;
        abstract readLine(): string;
        abstract readShort(): number;
        abstract close(): void;
        abstract readUTF(): string;
        abstract available(): number;
        abstract read(arg0: number[]): number;
        abstract readChar(): string;
    }
    type ObjectInput_ = ObjectInput;
    interface BeaconBeamBlock {
        abstract getColor(): Internal.DyeColor;
        get color(): Internal.DyeColor
        (): Internal.DyeColor_;
    }
    type BeaconBeamBlock_ = BeaconBeamBlock;
    class MutableBoolean implements Internal.Comparable<Internal.MutableBoolean>, Internal.Mutable<boolean>, Internal.Serializable {
        constructor()
        constructor(arg0: boolean)
        constructor(arg0: boolean)
        setValue(arg0: boolean): void;
        setTrue(): void;
        toBoolean(): boolean;
        getValue(): boolean;
        isTrue(): boolean;
        isFalse(): boolean;
        booleanValue(): boolean;
        setValue(arg0: boolean): void;
        setValue(arg0: any): void;
        setFalse(): void;
        compareTo(arg0: any): number;
        compareTo(arg0: Internal.MutableBoolean_): number;
        set value(arg0: boolean)
        get value(): boolean
        get "true"(): boolean
        get "false"(): boolean
        set value(arg0: boolean)
        set value(arg0: any)
    }
    type MutableBoolean_ = MutableBoolean;
    class DeadCoralPatchFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type DeadCoralPatchFeature_ = DeadCoralPatchFeature;
    class ReportEvidence {
        constructor(arg0: Internal.List_<Internal.ReportChatMessage>)
        messages: Internal.List<Internal.ReportChatMessage>;
    }
    type ReportEvidence_ = ReportEvidence;
    interface EquipmentSlotProvider {
        abstract getPreferredEquipmentSlot(arg0: Internal.ItemStack_): Internal.EquipmentSlot;
        (arg0: Internal.ItemStack): Internal.EquipmentSlot_;
    }
    type EquipmentSlotProvider_ = EquipmentSlotProvider;
    class Strider extends Internal.Animal implements Internal.ItemSteerable, Internal.Saddleable {
        constructor($$0: Internal.EntityType_<Internal.Strider>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        boost(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        setSuffocating($$0: boolean): void;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        static checkStriderSpawnRules($$0: Internal.EntityType_<Internal.Strider>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.RandomSource_): boolean;
        damageHeldItem(): void;
        getSaddleSoundEvent(): Internal.SoundEvent;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        isSuffocating(): boolean;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        isSaddled(): boolean;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        getBreedOffspring($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): this;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        isSaddleable(): boolean;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        equipSaddle($$0: Internal.SoundSource_): void;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        set suffocating($$0: boolean)
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get saddleSoundEvent(): Internal.SoundEvent
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get suffocating(): boolean
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get saddled(): boolean
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get saddleable(): boolean
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Strider_ = Strider;
    class LegacySinglePoolElement extends Internal.SinglePoolElement {
        static readonly CODEC: Internal.Codec<Internal.LegacySinglePoolElement>;
    }
    type LegacySinglePoolElement_ = LegacySinglePoolElement;
    class RaidDebugRenderer implements Internal.DebugRenderer$SimpleDebugRenderer {
        constructor($$0: Internal.Minecraft_)
        setRaidCenters($$0: Internal.Collection_<BlockPos>): void;
        render($$0: Internal.PoseStack_, $$1: Internal.MultiBufferSource_, $$2: number, $$3: number, $$4: number): void;
        clear(): void;
        set raidCenters($$0: Internal.Collection_<BlockPos>)
    }
    type RaidDebugRenderer_ = RaidDebugRenderer;
    interface DoubleUnaryOperator {
        compose(arg0: Internal.DoubleUnaryOperator_): this;
        andThen(arg0: Internal.DoubleUnaryOperator_): this;
        identity(): this;
        abstract applyAsDouble(arg0: number): number;
        (arg0: number): number;
    }
    type DoubleUnaryOperator_ = DoubleUnaryOperator;
    class TridentImpalerEnchantment extends Internal.Enchantment {
        constructor($$0: Internal.Enchantment$Rarity_, ...$$1: Internal.EquipmentSlot_[])
    }
    type TridentImpalerEnchantment_ = TridentImpalerEnchantment;
    class ContentsFilterType extends Internal.Enum<Internal.ContentsFilterType> implements Internal.StringRepresentable {
        static values(): Internal.ContentsFilterType[];
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf(name: string): Internal.ContentsFilterType;
        getSerializedName(): string;
        static fromName(name: string): Internal.ContentsFilterType;
        next(): this;
        get serializedName(): string
        static readonly BLOCK: Internal.ContentsFilterType;
        static readonly STORAGE: Internal.ContentsFilterType;
        static readonly ALLOW: Internal.ContentsFilterType;
    }
    type ContentsFilterType_ = "block" | "allow" | "storage" | ContentsFilterType;
    interface ParentComponent extends io.wispforest.owo.ui.core.Component {
        abstract queue(arg0: Internal.Runnable_): void;
        interpolate(arg0: Internal.Animatable_<any>, arg1: number): Internal.Animatable<any>;
        abstract allowOverflow(): boolean;
        abstract horizontalSizing(): Internal.AnimatableProperty<Internal.Sizing>;
        intersects(other: Internal.PositionedRectangle_): boolean;
        abstract x(): number;
        abstract charTyped(): Internal.EventSource<Internal.CharTyped>;
        abstract horizontalSizing(arg0: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        abstract updateX(arg0: number): void;
        abstract horizontalAlignment(): Internal.HorizontalAlignment;
        abstract mouseLeave(): Internal.EventSource<Internal.MouseLeave>;
        update(delta: number, mouseX: number, mouseY: number): void;
        abstract verticalAlignment(arg0: Internal.VerticalAlignment_): this;
        abstract verticalSizing(): Internal.AnimatableProperty<Internal.Sizing>;
        remove(): void;
        hasParent(): boolean;
        abstract removeChild(arg0: io.wispforest.owo.ui.core.Component_): this;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        collectChildren(into: Internal.ArrayList_<io.wispforest.owo.ui.core.Component>): void;
        drawTooltip(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        abstract allowOverflow(arg0: boolean): this;
        abstract onFocusGained(arg0: Internal.Component$FocusSource_): void;
        abstract draw(arg0: Internal.OwoUIDrawContext_, arg1: number, arg2: number, arg3: number, arg4: number): void;
        abstract surface(): Internal.Surface;
        abstract height(): number;
        sizing(horizontalSizing: Internal.Sizing_, verticalSizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        childById<T extends io.wispforest.owo.ui.core.Component>(expectedClass: T, id: string): T;
        abstract positioning(arg0: Internal.Positioning_): io.wispforest.owo.ui.core.Component;
        abstract onCharTyped(arg0: string, arg1: number): boolean;
        abstract focusLost(): Internal.EventSource<Internal.FocusLost>;
        abstract focusHandler(): Internal.FocusHandler;
        abstract id(): string;
        abstract margins(): Internal.AnimatableProperty<io.wispforest.owo.ui.core.Insets>;
        abstract onMouseUp(arg0: number, arg1: number, arg2: number): boolean;
        collectDescendants(into: Internal.ArrayList_<io.wispforest.owo.ui.core.Component>): void;
        abstract configure<C extends io.wispforest.owo.ui.core.Component>(arg0: Internal.Consumer_<C>): C;
        intersection(other: Internal.PositionedRectangle_): Internal.PositionedRectangle;
        abstract layout(arg0: Internal.Size_): void;
        onMouseScroll(mouseX: number, mouseY: number, amount: number): boolean;
        abstract tooltip(arg0: Internal.List_<Internal.ClientTooltipComponent>): io.wispforest.owo.ui.core.Component;
        abstract inflate(arg0: Internal.Size_): void;
        abstract width(): number;
        interpolate(next: Internal.PositionedRectangle_, delta: number): Internal.PositionedRectangle;
        root(): this;
        abstract mouseUp(): Internal.EventSource<Internal.MouseUp>;
        abstract onKeyPress(arg0: number, arg1: number, arg2: number): boolean;
        abstract parent(): this;
        abstract cursorStyle(): Internal.CursorStyle;
        tooltip(tooltip: net.minecraft.network.chat.Component_): io.wispforest.owo.ui.core.Component;
        shouldDrawTooltip(mouseX: number, mouseY: number): boolean;
        of(x: number, y: number, width: number, height: number): Internal.PositionedRectangle;
        abstract keyPress(): Internal.EventSource<Internal.KeyPress>;
        abstract padding(): Internal.AnimatableProperty<io.wispforest.owo.ui.core.Insets>;
        abstract y(): number;
        abstract horizontalAlignment(arg0: Internal.HorizontalAlignment_): this;
        abstract id(arg0: string): io.wispforest.owo.ui.core.Component;
        abstract mouseEnter(): Internal.EventSource<Internal.MouseEnter>;
        abstract updateY(arg0: number): void;
        moveTo(x: number, y: number): void;
        abstract verticalAlignment(): Internal.VerticalAlignment;
        isInBoundingBox(x: number, y: number): boolean;
        fullSize(): Internal.Size;
        alignment(horizontalAlignment: Internal.HorizontalAlignment_, verticalAlignment: Internal.VerticalAlignment_): this;
        abstract mouseDown(): Internal.EventSource<Internal.MouseDown>;
        abstract onMouseDrag(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number): boolean;
        abstract zIndex(): number;
        onMouseDown(mouseX: number, mouseY: number, button: number): boolean;
        abstract zIndex(arg0: number): io.wispforest.owo.ui.core.Component;
        parseProperties(model: Internal.UIModel_, element: Internal.Element_, children: Internal.Map_<string, Internal.Element>): void;
        abstract padding(arg0: io.wispforest.owo.ui.core.Insets_): this;
        tooltip(tooltip: Internal.Collection_<net.minecraft.network.chat.Component>): io.wispforest.owo.ui.core.Component;
        abstract mouseScroll(): Internal.EventSource<Internal.MouseScroll>;
        abstract focusGained(): Internal.EventSource<Internal.FocusGained>;
        abstract surface(arg0: Internal.Surface_): this;
        abstract onFocusLost(): void;
        childAt(x: number, y: number): io.wispforest.owo.ui.core.Component;
        forEachDescendant(action: Internal.Consumer_<io.wispforest.owo.ui.core.Component>): void;
        abstract mount(arg0: Internal.ParentComponent_, arg1: number, arg2: number): void;
        abstract mouseDrag(): Internal.EventSource<Internal.MouseDrag>;
        sizing(sizing: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        abstract onChildMutated(arg0: io.wispforest.owo.ui.core.Component_): void;
        drawFocusHighlight(context: Internal.OwoUIDrawContext_, mouseX: number, mouseY: number, partialTicks: number, delta: number): void;
        abstract tooltip(): Internal.List<Internal.ClientTooltipComponent>;
        abstract verticalSizing(arg0: Internal.Sizing_): io.wispforest.owo.ui.core.Component;
        of(x: number, y: number, size: Internal.Size_): Internal.PositionedRectangle;
        abstract cursorStyle(arg0: Internal.CursorStyle_): io.wispforest.owo.ui.core.Component;
        canFocus(source: Internal.Component$FocusSource_): boolean;
        abstract children(): Internal.List<io.wispforest.owo.ui.core.Component>;
        abstract positioning(): Internal.AnimatableProperty<Internal.Positioning>;
        abstract margins(arg0: io.wispforest.owo.ui.core.Insets_): io.wispforest.owo.ui.core.Component;
        abstract dismount(arg0: Internal.Component$DismountReason_): void;
    }
    type ParentComponent_ = ParentComponent;
    interface Thread$UncaughtExceptionHandler {
        abstract uncaughtException(arg0: Internal.Thread_, arg1: Internal.Throwable_): void;
        (arg0: Internal.Thread, arg1: Internal.Throwable): void;
    }
    type Thread$UncaughtExceptionHandler_ = Thread$UncaughtExceptionHandler;
    class DieselSmokeStackBlockEntity extends Internal.SmartBlockEntity implements Internal.ISpeedNotifiable {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getFanRotation(rpm: number): number;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getRpm(partialTicks: number): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        notifySpeed(speed: number): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get infiniteBoundingBox(): Internal.AABB
    }
    type DieselSmokeStackBlockEntity_ = DieselSmokeStackBlockEntity;
    class HatShapedRecipe$Serializer implements Internal.RecipeSerializer<Internal.HatShapedRecipe> {
        read(identifier: ResourceLocation_, jsonObject: Internal.JsonObject_): Internal.HatShapedRecipe;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        read(identifier: ResourceLocation_, packetByteBuf: Internal.FriendlyByteBuf_): Internal.HatShapedRecipe;
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): Internal.Recipe<any>;
        write(packetByteBuf: Internal.FriendlyByteBuf_, shapedRecipe: Internal.HatShapedRecipe_): void;
        toNetwork(buf: Internal.FriendlyByteBuf_, recipe: Internal.Recipe_<any>): void;
        fromNetwork(id: ResourceLocation_, buf: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
        static readonly INSTANCE: Internal.HatShapedRecipe$Serializer;
    }
    type HatShapedRecipe$Serializer_ = HatShapedRecipe$Serializer;
    interface ChronoLocalDate extends Internal.Comparable<Internal.ChronoLocalDate>, Internal.Temporal, Internal.TemporalAdjuster {
        lengthOfYear(): number;
        abstract until(arg0: Internal.ChronoLocalDate_): Internal.ChronoPeriod;
        plus(arg0: Internal.TemporalAmount_): this;
        isAfter(arg0: Internal.ChronoLocalDate_): boolean;
        compareTo(arg0: any): number;
        getEra(): Internal.Era;
        "with"(arg0: Internal.TemporalAdjuster_): Internal.Temporal;
        abstract getLong(arg0: Internal.TemporalField_): number;
        minus(arg0: number, arg1: Internal.TemporalUnit_): Internal.Temporal;
        isSupported(arg0: Internal.TemporalField_): boolean;
        format(arg0: Internal.DateTimeFormatter_): string;
        toEpochDay(): number;
        abstract getChronology(): Internal.Chronology;
        abstract toString(): string;
        adjustInto(arg0: Internal.Temporal_): Internal.Temporal;
        timeLineOrder(): Internal.Comparator<Internal.ChronoLocalDate>;
        query<R>(arg0: Internal.TemporalQuery_<R>): R;
        abstract until(arg0: Internal.Temporal_, arg1: Internal.TemporalUnit_): number;
        isSupported(arg0: Internal.TemporalUnit_): boolean;
        compareTo(arg0: Internal.ChronoLocalDate_): number;
        "with"(arg0: Internal.TemporalField_, arg1: number): this;
        atTime(arg0: Internal.LocalTime_): Internal.ChronoLocalDateTime<any>;
        range(arg0: Internal.TemporalField_): Internal.ValueRange;
        abstract hashCode(): number;
        plus(arg0: number, arg1: Internal.TemporalUnit_): this;
        isEqual(arg0: Internal.ChronoLocalDate_): boolean;
        get(arg0: Internal.TemporalField_): number;
        abstract lengthOfMonth(): number;
        abstract equals(arg0: any): boolean;
        from(arg0: Internal.TemporalAccessor_): this;
        isBefore(arg0: Internal.ChronoLocalDate_): boolean;
        minus(arg0: Internal.TemporalAmount_): Internal.Temporal;
        isLeapYear(): boolean;
        get era(): Internal.Era
        get chronology(): Internal.Chronology
        get leapYear(): boolean
    }
    type ChronoLocalDate_ = ChronoLocalDate;
    class InscriberRecipe implements Internal.Recipe<net.minecraft.world.Container> {
        constructor(id: ResourceLocation_, middleInput: Internal.Ingredient_, output: Internal.ItemStack_, topOptional: Internal.Ingredient_, bottomOptional: Internal.Ingredient_, processType: Internal.InscriberProcessType_)
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(inv: net.minecraft.world.Container_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(inv: net.minecraft.world.Container_, level: Internal.Level_): boolean;
        getResultItem(): Internal.ItemStack;
        getMod(): string;
        getRemainingItems($$0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        getBottomOptional(): Internal.Ingredient;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getTopOptional(): Internal.Ingredient;
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getMiddleInput(): Internal.Ingredient;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        getProcessType(): Internal.InscriberProcessType;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get resultItem(): Internal.ItemStack
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get bottomOptional(): Internal.Ingredient
        get special(): boolean
        get topOptional(): Internal.Ingredient
        get type(): ResourceLocation
        set group(group: string)
        get middleInput(): Internal.Ingredient
        get orCreateId(): ResourceLocation
        get processType(): Internal.InscriberProcessType
        get incomplete(): boolean
        static readonly TYPE_ID: ResourceLocation;
        static readonly TYPE: Internal.RecipeType$1;
    }
    type InscriberRecipe_ = InscriberRecipe;
    class GuiGraphics$ScissorStack {
        push($$0: Internal.ScreenRectangle_): Internal.ScreenRectangle;
        pop(): Internal.ScreenRectangle;
    }
    type GuiGraphics$ScissorStack_ = GuiGraphics$ScissorStack;
    abstract class MemorySessionImpl implements Internal.MemorySegment$Scope {
        static checkValidState(arg0: Internal.MemorySegment_): void;
        allocate(arg0: number, arg1: number): Internal.MemorySegment;
        abstract acquire0(): void;
        checkValidStateRaw(): void;
        asArena(): Internal.Arena;
        isCloseableBy(arg0: Internal.Thread_): boolean;
        static createShared(): Internal.MemorySessionImpl;
        checkValidState(): void;
        ownerThread(): Internal.Thread;
        isCloseable(): boolean;
        static createImplicit(arg0: Internal.Cleaner_): Internal.MemorySessionImpl;
        addOrCleanupIfFail(arg0: Internal.MemorySessionImpl$ResourceList$ResourceCleanup_): void;
        isAccessibleBy(arg0: Internal.Thread_): boolean;
        static heapSession(arg0: any): Internal.MemorySessionImpl;
        abstract release0(): void;
        static createConfined(arg0: Internal.Thread_): Internal.MemorySessionImpl;
        close(): void;
        static toMemorySession(arg0: Internal.Arena_): Internal.MemorySessionImpl;
        whileAlive(arg0: Internal.Runnable_): void;
        isAlive(): boolean;
        addCloseAction(arg0: Internal.Runnable_): void;
        get closeable(): boolean
        get alive(): boolean
        static readonly GLOBAL: Internal.MemorySessionImpl;
    }
    type MemorySessionImpl_ = MemorySessionImpl;
    class ResourceOrTagArgument$Info$Template implements Internal.ArgumentTypeInfo$Template<Internal.ResourceOrTagArgument<T>> {
        instantiate(arg0: Internal.CommandBuildContext_): Internal.ArgumentType<any>;
        instantiate($$0: Internal.CommandBuildContext_): Internal.ResourceOrTagArgument<T>;
        type(): Internal.ArgumentTypeInfo<Internal.ResourceOrTagArgument<T>, any>;
    }
    type ResourceOrTagArgument$Info$Template_ = ResourceOrTagArgument$Info$Template;
    class CropStickVariant extends Internal.Enum<Internal.CropStickVariant> implements Internal.StringRepresentable {
        getSound(): SoundType;
        playSound(level: Internal.Level_, pos: BlockPos_): void;
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.CropStickVariant[];
        getSerializedName(): string;
        static fromItem(stack: Internal.ItemStack_): Internal.CropStickVariant;
        static toItem(variant: Internal.CropStickVariant_, amount: number): Internal.ItemStack;
        static toItem(variant: Internal.CropStickVariant_): Internal.ItemStack;
        static valueOf(name: string): Internal.CropStickVariant;
        get sound(): SoundType
        get serializedName(): string
        static readonly WOODEN: Internal.CropStickVariant;
        static readonly IRON: Internal.CropStickVariant;
        static readonly OBSIDIAN: Internal.CropStickVariant;
    }
    type CropStickVariant_ = CropStickVariant | "wooden" | "obsidian" | "iron";
    interface LivingEntityEvents$KnockBackStrength {
        abstract onLivingEntityTakeKnockback(arg0: number, arg1: Internal.Player_): number;
        (arg0: number, arg1: Internal.Player): number;
    }
    type LivingEntityEvents$KnockBackStrength_ = LivingEntityEvents$KnockBackStrength;
    class ItemDragonSteelArmor extends Internal.ArmorItem implements Internal.IProtectAgainstDragonItem {
        constructor(material: Internal.ArmorMaterial_, renderIndex: number, slot: Internal.ArmorItem$Type_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        swapWithEquipmentSlot($$0: Internal.Item_, $$1: Internal.Level_, $$2: Internal.Player_, $$3: Internal.InteractionHand_): Internal.InteractionResultHolder<Internal.ItemStack>;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemDragonSteelArmor_ = ItemDragonSteelArmor;
    interface InventoryIdentifier$Finder {
        abstract find(arg0: Internal.Level_, arg1: Internal.BlockState_, arg2: Internal.BlockFace_): Internal.InventoryIdentifier;
        (arg0: Internal.Level, arg1: Internal.BlockState, arg2: Internal.BlockFace): Internal.InventoryIdentifier_;
    }
    type InventoryIdentifier$Finder_ = InventoryIdentifier$Finder;
    interface ScreenExtensions {
        abstract fabric_getBeforeRenderEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenEvents$BeforeRender>;
        abstract fabric_getAllowMouseScrollEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenMouseEvents$AllowMouseScroll>;
        abstract fabric_getBeforeTickEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenEvents$BeforeTick>;
        abstract fabric_getAllowMouseReleaseEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenMouseEvents$AllowMouseRelease>;
        abstract fabric_getAfterMouseClickEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenMouseEvents$AfterMouseClick>;
        abstract fabric_getAllowKeyReleaseEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenKeyboardEvents$AllowKeyRelease>;
        abstract fabric_getBeforeMouseClickEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenMouseEvents$BeforeMouseClick>;
        abstract fabric_getButtons(): Internal.List<Internal.AbstractWidget>;
        abstract fabric_getAfterKeyPressEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenKeyboardEvents$AfterKeyPress>;
        abstract fabric_getBeforeKeyPressEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenKeyboardEvents$BeforeKeyPress>;
        abstract fabric_getAfterMouseReleaseEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenMouseEvents$AfterMouseRelease>;
        abstract fabric_getRemoveEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenEvents$Remove>;
        abstract fabric_getAllowMouseClickEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenMouseEvents$AllowMouseClick>;
        abstract fabric_getAfterMouseScrollEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenMouseEvents$AfterMouseScroll>;
        abstract fabric_getBeforeMouseScrollEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenMouseEvents$BeforeMouseScroll>;
        abstract fabric_getAfterTickEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenEvents$AfterTick>;
        abstract fabric_getBeforeMouseReleaseEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenMouseEvents$BeforeMouseRelease>;
        getExtensions(screen: Internal.Screen_): this;
        abstract fabric_getAfterKeyReleaseEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenKeyboardEvents$AfterKeyRelease>;
        abstract fabric_getBeforeKeyReleaseEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenKeyboardEvents$BeforeKeyRelease>;
        abstract fabric_getAllowKeyPressEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenKeyboardEvents$AllowKeyPress>;
        abstract fabric_getAfterRenderEvent(): net.fabricmc.fabric.api.event.Event<Internal.ScreenEvents$AfterRender>;
    }
    type ScreenExtensions_ = ScreenExtensions;
    class CampsiteFeature extends Internal.Feature<any> {
        constructor()
        placeChest(level: Internal.WorldGenLevel_, pos: BlockPos_, random: Internal.RandomSource_, facing: Internal.Direction_): void;
        static readonly BARREL_LOOT: ResourceLocation;
        static readonly CHEST_LOOT: ResourceLocation;
    }
    type CampsiteFeature_ = CampsiteFeature;
    class ClientboundAddEntityPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.Entity_, $$1: number, $$2: BlockPos_)
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.Entity_, $$1: number)
        constructor($$0: number, $$1: Internal.UUID_, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: Internal.EntityType_<any>, $$8: number, $$9: Vec3d_, $$10: number)
        constructor($$0: Internal.Entity_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getData(): number;
        getXRot(): number;
        getZa(): number;
        isSkippable(): boolean;
        getX(): number;
        getY(): number;
        getZ(): number;
        getXa(): number;
        getYa(): number;
        getYRot(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getUUID(): Internal.UUID;
        getYHeadRot(): number;
        getType(): Internal.EntityType<any>;
        getId(): number;
        get data(): number
        get XRot(): number
        get za(): number
        get skippable(): boolean
        get x(): number
        get y(): number
        get z(): number
        get xa(): number
        get ya(): number
        get YRot(): number
        get UUID(): Internal.UUID
        get YHeadRot(): number
        get type(): Internal.EntityType<any>
        get id(): number
    }
    type ClientboundAddEntityPacket_ = ClientboundAddEntityPacket;
    interface IntStream$IntMapMultiConsumer {
        abstract accept(arg0: number, arg1: Internal.IntConsumer_): void;
        (arg0: number, arg1: Internal.IntConsumer): void;
    }
    type IntStream$IntMapMultiConsumer_ = IntStream$IntMapMultiConsumer;
    interface InlineStyle {
        setComponent<C>(component: Internal.InlineStyle$ISComponent_<C>, value: C): Internal.Style;
        getComponents(): Internal.Set<Internal.InlineStyle$ISComponent<any>>;
        makeCopy(original: Internal.Style_): Internal.Style;
        getInlineData(): Internal.InlineData<any>;
        withInlineData(data: Internal.InlineData_<any>): Internal.Style;
        getComponent<C>(component: Internal.InlineStyle$ISComponent_<C>): C;
        withComponent<C>(component: Internal.InlineStyle$ISComponent_<C>, value: C): Internal.Style;
        fromInlineData(data: Internal.InlineData_<any>): Internal.Style;
        get components(): Internal.Set<Internal.InlineStyle$ISComponent<any>>
        get inlineData(): Internal.InlineData<any>
        readonly HIDDEN_COMP: Internal.InlineStyle$ISComponent<boolean>;
        readonly GLOWY_MARKER_COMP: Internal.InlineStyle$ISComponent<boolean>;
        readonly INLINE_DATA_COMP: Internal.InlineStyle$ISComponent<Internal.InlineData<any>>;
        readonly SIZE_MODIFIER_COMP: Internal.InlineStyle$ISComponent<number>;
        readonly GLOWY_PARENT_COMP: Internal.InlineStyle$ISComponent<number>;
    }
    type InlineStyle_ = InlineStyle;
    class MinecraftRemapper implements Internal.Remapper {
        getMappedClass(from: typeof any): string;
        getUnmappedClass(mmName: string): string;
        getMappedField(from: typeof any, field: Internal.Field_): string;
        static getTypeName(type: string): string;
        getMappedMethod(from: typeof any, method: Internal.Method_): string;
        static load(stream: Internal.InputStream_, debug: boolean): Internal.MinecraftRemapper;
    }
    type MinecraftRemapper_ = MinecraftRemapper;
    class ChunkStorage implements Internal.AutoCloseable {
        constructor($$0: Internal.Path_, $$1: Internal.DataFixer_, $$2: boolean)
        chunkScanner(): Internal.ChunkScanAccess;
        read($$0: Internal.ChunkPos_): Internal.CompletableFuture<Internal.Optional<Internal.CompoundTag>>;
        isOldChunkAround($$0: Internal.ChunkPos_, $$1: number): boolean;
        close(): void;
        flushWorker(): void;
        write($$0: Internal.ChunkPos_, $$1: Internal.CompoundTag_): void;
        upgradeChunkTag($$0: Internal.ResourceKey_<Internal.Level>, $$1: Internal.Supplier_<Internal.DimensionDataStorage>, $$2: Internal.CompoundTag_, $$3: Internal.Optional_<Internal.ResourceKey<Internal.Codec<Internal.ChunkGenerator>>>): Internal.CompoundTag;
        static injectDatafixingContext($$0: Internal.CompoundTag_, $$1: Internal.ResourceKey_<Internal.Level>, $$2: Internal.Optional_<Internal.ResourceKey<Internal.Codec<Internal.ChunkGenerator>>>): void;
        static getVersion($$0: Internal.CompoundTag_): number;
        static readonly LAST_MONOLYTH_STRUCTURE_DATA_VERSION: 1493;
    }
    type ChunkStorage_ = ChunkStorage;
    class LeashFenceKnotEntity extends Internal.HangingEntity {
        constructor($$0: Internal.Level_, $$1: BlockPos_)
        constructor($$0: Internal.EntityType_<Internal.LeashFenceKnotEntity>, $$1: Internal.Level_)
        static getOrCreateKnot($$0: Internal.Level_, $$1: BlockPos_): Internal.LeashFenceKnotEntity;
        setMotionY(y: number): void;
        isPeacefulCreature(): boolean;
        getDistance(pos: BlockPos_): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        setRotation(yaw: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        isOnScoreboardTeam(teamId: string): boolean;
        getType(): string;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        self(): Internal.Entity;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        setPosition(x: number, y: number, z: number): void;
        getPassengers(): Internal.EntityArrayList;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnBlockCacheSet(newState: Internal.BlockState_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isLiving(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        alwaysAccepts(): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        getDisplayName(): net.minecraft.network.chat.Component;
        setMotionX(x: number): void;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        method_6892($$0: Internal.Direction_): void;
        attack(hp: number): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTeamId(): string;
        setNbt(nbt: Internal.CompoundTag_): void;
        lithiumSetClimbingMobCachingSectionUpdateBehavior(listening: boolean): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        serializeNBT(): Internal.Tag;
        setDynamicLightEnabled(enabled: boolean): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        isFrame(): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getProfile(): Internal.GameProfile;
        playSound(id: Internal.SoundEvent_): void;
        lithiumOnBlockCacheDeleted(): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        runCommand(command: string): number;
        getDistance(x: number, y: number, z: number): number;
        set motionY(y: number)
        get peacefulCreature(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get server(): Internal.MinecraftServer
        get displayName(): net.minecraft.network.chat.Component
        set motionX(x: number)
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        get facing(): Internal.Direction
        set dynamicLightEnabled(enabled: boolean)
        get motionX(): number
        get waterCreature(): boolean
        get motionZ(): number
        get item(): Internal.ItemStack
        set x(x: number)
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get frame(): boolean
        get profile(): Internal.GameProfile
        static readonly OFFSET_Y: 0.375;
    }
    type LeashFenceKnotEntity_ = LeashFenceKnotEntity;
    class ScoreHolderArgument implements Internal.ArgumentType<Internal.ScoreHolderArgument$Result> {
        constructor($$0: boolean)
        getExamples(): Internal.Collection<string>;
        static getNamesWithDefaultWildcard($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Collection<string>;
        static getNames($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string, $$2: Internal.Supplier_<Internal.Collection<string>>): Internal.Collection<string>;
        static scoreHolders(): Internal.ScoreHolderArgument;
        static getNames($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): Internal.Collection<string>;
        parse($$0: Internal.StringReader_): Internal.ScoreHolderArgument$Result;
        listSuggestions<S>(arg0: Internal.CommandContext_<S>, arg1: Internal.SuggestionsBuilder_): Internal.CompletableFuture<Internal.Suggestions>;
        parse(arg0: Internal.StringReader_): any;
        static scoreHolder(): Internal.ScoreHolderArgument;
        static getName($$0: Internal.CommandContext_<Internal.CommandSourceStack>, $$1: string): string;
        get examples(): Internal.Collection<string>
        static readonly SUGGEST_SCORE_HOLDERS: Internal.SuggestionProvider<Internal.CommandSourceStack>;
    }
    type ScoreHolderArgument_ = ScoreHolderArgument;
    interface MethodHandleDesc extends Internal.ConstantDesc {
        asType(arg0: Internal.MethodTypeDesc_): this;
        of(arg0: Internal.DirectMethodHandleDesc$Kind_, arg1: Internal.ClassDesc_, arg2: string, arg3: string): Internal.DirectMethodHandleDesc;
        abstract invocationType(): Internal.MethodTypeDesc;
        resolveConstantDesc(arg0: Internal.MethodHandles$Lookup_): any;
        ofConstructor(arg0: Internal.ClassDesc_, ...arg1: Internal.ClassDesc_[]): Internal.DirectMethodHandleDesc;
        ofField(arg0: Internal.DirectMethodHandleDesc$Kind_, arg1: Internal.ClassDesc_, arg2: string, arg3: Internal.ClassDesc_): Internal.DirectMethodHandleDesc;
        abstract equals(arg0: any): boolean;
        ofMethod(arg0: Internal.DirectMethodHandleDesc$Kind_, arg1: Internal.ClassDesc_, arg2: string, arg3: Internal.MethodTypeDesc_): Internal.DirectMethodHandleDesc;
    }
    type MethodHandleDesc_ = MethodHandleDesc;
    class ContentsFilterLogic extends Internal.FilterLogic {
        constructor(upgrade: Internal.ItemStack_, saveHandler: Internal.Consumer_<Internal.ItemStack>, filterSlotCount: number, getInventoryHandler: Internal.Supplier_<Internal.InventoryHandler>, memorySettings: any_)
        constructor(upgrade: Internal.ItemStack_, saveHandler: Internal.Consumer_<Internal.ItemStack>, filterSlotCount: number, getInventoryHandler: Internal.Supplier_<Internal.InventoryHandler>, memorySettings: any_, parentTagKey: string)
        setDepositFilterType(contentsFilterType: Internal.ContentsFilterType_): void;
        getFilterType(): Internal.ContentsFilterType;
        set depositFilterType(contentsFilterType: Internal.ContentsFilterType_)
        get filterType(): Internal.ContentsFilterType
    }
    type ContentsFilterLogic_ = ContentsFilterLogic;
    class CursorStyle extends Internal.Enum<Internal.CursorStyle> {
        static valueOf(name: string): Internal.CursorStyle;
        static values(): Internal.CursorStyle[];
        static readonly NONE: Internal.CursorStyle;
        static readonly POINTER: Internal.CursorStyle;
        static readonly TEXT: Internal.CursorStyle;
        readonly glfw: number;
        static readonly HAND: Internal.CursorStyle;
        static readonly MOVE: Internal.CursorStyle;
    }
    type CursorStyle_ = "text" | "move" | "pointer" | CursorStyle | "hand" | "none";
    interface UnaryOperator <T> extends Internal.Function<T, T> {
        identity<T>(): this;
        abstract apply(arg0: T): T;
        andThen<V>(arg0: Internal.Function_<T, V>): Internal.Function<T, V>;
        compose<V>(arg0: Internal.Function_<V, T>): Internal.Function<V, T>;
        (arg0: T): T;
    }
    type UnaryOperator_<T> = UnaryOperator<T>;
    class WitherBoss extends Internal.Monster implements Internal.PowerableMob, Internal.RangedAttackMob {
        constructor($$0: Internal.EntityType_<Internal.WitherBoss>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getInvulnerableTicks(): number;
        setInvulnerableTicks($$0: number): void;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        isPowered(): boolean;
        getBlock(): Internal.BlockContainerJS;
        makeInvulnerable(): void;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        modifyExpressionValue$zee000$porting_lib_base$port_lib$canDestroy(original: boolean): boolean;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getHeadXRot($$0: number): number;
        handler$zee000$porting_lib_base$port_lib$shouldDestroy(ci: Internal.CallbackInfo_, i: number, j: number, k: number, bl: boolean, l: number, m: number, n: number, o: number, p: number, q: number, blockPos: BlockPos_): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        performRangedAttack($$0: Internal.LivingEntity_, $$1: number): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        getHeadYRot($$0: number): number;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        modifyExpressionValue$hpe000$sophisticatedbackpacks$sophisticatedBackpacks$checkWalls(original: boolean, blockPos: BlockPos_, blockState: Internal.BlockState_): boolean;
        getHeadArmorItem(): Internal.ItemStack;
        getAlternativeTarget($$0: number): number;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        setAlternativeTarget($$0: number, $$1: number): void;
        tell(message: net.minecraft.network.chat.Component_): void;
        static canDestroy($$0: Internal.BlockState_): boolean;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get invulnerableTicks(): number
        set invulnerableTicks($$0: number)
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get powered(): boolean
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type WitherBoss_ = WitherBoss;
    class PalettedContainer <T> implements Internal.PaletteResize<T>, Internal.ReadableContainerExtended<any>, Internal.PalettedContainerRO<T> {
        constructor($$0: Internal.IdMap_<T>, $$1: T, $$2: Internal.PalettedContainer$Strategy_)
        constructor($$0: Internal.IdMap_<T>, $$1: Internal.PalettedContainer$Strategy_, $$2: Internal.PalettedContainer$Configuration_<T>, $$3: Internal.BitStorage_, $$4: Internal.List_<T>)
        handler$eia000$lithium$count(consumer: Internal.PalettedContainer$CountConsumer_<any>, ci: Internal.CallbackInfo_): void;
        getAndSet($$0: number, $$1: number, $$2: number, $$3: T): T;
        getSerializedSize(): number;
        sodium$copy(): Internal.PalettedContainerRO<any>;
        sodium$unpack(values: any[], minX: number, minY: number, minZ: number, maxX: number, maxY: number, maxZ: number): void;
        sodium$unpack(values: any[]): void;
        getAll($$0: Internal.Consumer_<T>): void;
        static codecRW<T>($$0: Internal.IdMap_<T>, $$1: Internal.Codec_<T>, $$2: Internal.PalettedContainer$Strategy_, $$3: T): Internal.Codec<Internal.PalettedContainer<T>>;
        recreate(): this;
        get($$0: number): T;
        getAndSetUnchecked($$0: number, $$1: number, $$2: number, $$3: T): T;
        static of<T>(container: Internal.PalettedContainerRO_<T>): Internal.ReadableContainerExtended<T>;
        get($$0: number, $$1: number, $$2: number): T;
        read($$0: Internal.FriendlyByteBuf_): void;
        maybeHas($$0: Internal.Predicate_<T>): boolean;
        write($$0: Internal.FriendlyByteBuf_): void;
        pack(idList: Internal.IdMap_<any>, provider: Internal.PalettedContainer$Strategy_): Internal.PalettedContainerRO$PackedData<any>;
        set($$0: number, $$1: number, $$2: number, $$3: T): void;
        onResize($$0: number, $$1: T): number;
        handler$ehn000$lithium$removeLockHelper(ci: Internal.CallbackInfo_): void;
        count($$0: Internal.PalettedContainer$CountConsumer_<T>): void;
        copy(): this;
        static clone<T>(container: Internal.PalettedContainerRO_<T>): Internal.PalettedContainerRO<T>;
        release(): void;
        acquire(): void;
        static codecRO<T>($$0: Internal.IdMap_<T>, $$1: Internal.Codec_<T>, $$2: Internal.PalettedContainer$Strategy_, $$3: T): Internal.Codec<Internal.PalettedContainerRO<T>>;
        get serializedSize(): number
    }
    type PalettedContainer_<T> = PalettedContainer<T>;
    interface BakedQuadExtensions {
        abstract port_lib$getRenderMaterial(): Internal.MaterialData;
        abstract port_lib$setRenderMaterial(arg0: Internal.MaterialData_): void;
    }
    type BakedQuadExtensions_ = BakedQuadExtensions;
    class MountedItemStorageWrapper extends Internal.CombinedSlottedStackStorage<Internal.MountedItemStorage> {
        constructor(storages: Internal.ImmutableMap_<BlockPos, Internal.MountedItemStorage>)
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.ItemVariant_): Internal.StorageView<Internal.ItemVariant>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        isItemValid(slot: number, resource: Internal.ItemVariant_): boolean;
        static asClass<T>(): Internal.Storage<T>;
        getSlots(): Internal.List<Internal.SingleSlotStorage<Internal.ItemVariant>>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<Internal.ItemVariant>>;
        static empty<T>(): Internal.Storage<T>;
        getVersion(): number;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        get slots(): Internal.List<Internal.SingleSlotStorage<Internal.ItemVariant>>
        get version(): number
        readonly storages: Internal.ImmutableMap<BlockPos, Internal.MountedItemStorage>;
    }
    type MountedItemStorageWrapper_ = MountedItemStorageWrapper;
    interface FabricBlockLootTableGenerator {
        withConditions(...conditions: any_[]): Internal.BlockLootSubProvider;
    }
    type FabricBlockLootTableGenerator_ = FabricBlockLootTableGenerator;
    class Camera$NearPlane {
        getBottomRight(): Vec3d;
        getPointOnPlane($$0: number, $$1: number): Vec3d;
        getTopLeft(): Vec3d;
        getBottomLeft(): Vec3d;
        getTopRight(): Vec3d;
        get bottomRight(): Vec3d
        get topLeft(): Vec3d
        get bottomLeft(): Vec3d
        get topRight(): Vec3d
    }
    type Camera$NearPlane_ = Camera$NearPlane;
    class PotionFluid extends Internal.VirtualFluid {
        constructor(properties: Internal.SimpleFlowableFluid$Properties_, source: boolean)
        static withEffects(amount: number, potion: Internal.Potion_, customEffects: Internal.List_<Internal.MobEffectInstance>): Internal.FluidStack;
        static addPotionToFluidStack(fs: Internal.FluidStack_, potion: Internal.Potion_): Internal.FluidStack;
        arch$holder(): Internal.Holder<Internal.Fluid>;
        static of(amount: number, potion: Internal.Potion_, bottleType: Internal.PotionFluid$BottleType_): Internal.FluidStack;
        static createFlowing(properties: Internal.SimpleFlowableFluid$Properties_): Internal.PotionFluid;
        arch$registryName(): ResourceLocation;
        static appendEffects(fs: Internal.FluidStack_, customEffects: Internal.Collection_<Internal.MobEffectInstance>): Internal.FluidStack;
        static createSource(properties: Internal.SimpleFlowableFluid$Properties_): Internal.PotionFluid;
    }
    type PotionFluid_ = PotionFluid;
    class ClearStainedGlassBlock extends Internal.AbstractGlassBlock implements Internal.BeaconColorMultiplierBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, glassColor: any_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getBeaconColorMultiplier(state: Internal.BlockState_, world: Internal.LevelReader_, pos: BlockPos_, beaconPos: BlockPos_): number[];
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type ClearStainedGlassBlock_ = ClearStainedGlassBlock;
    class HexPattern$Companion {
        constructor($constructor_marker: any_)
        fromNBT(tag: Internal.CompoundTag_): Internal.HexPattern;
        isPattern(tag: Internal.CompoundTag_): boolean;
        fromAnglesUnchecked(signature: string, startDir: Internal.HexDir_): Internal.HexPattern;
        fromAngles(signature: string, startDir: Internal.HexDir_): Internal.HexPattern;
    }
    type HexPattern$Companion_ = HexPattern$Companion;
    interface StatFormatter {
        abstract format(arg0: number): string;
        (arg0: number): string;
        readonly DECIMAL_FORMAT: Internal.DecimalFormat;
        readonly DIVIDE_BY_TEN: Internal.StatFormatter;
        readonly DISTANCE: Internal.StatFormatter;
        readonly DEFAULT: Internal.StatFormatter;
        readonly TIME: Internal.StatFormatter;
    }
    type StatFormatter_ = StatFormatter;
    class SearedLadderBlock extends Internal.OrientableSmelteryBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly BOTTOM: Internal.BooleanProperty;
    }
    type SearedLadderBlock_ = SearedLadderBlock;
    class ItemGeneric extends Internal.Item {
        constructor()
        constructor(textLength: number, stacksize: number)
        constructor(textLength: number, hide: boolean)
        constructor(textLength: number)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemGeneric_ = ItemGeneric;
    interface ExtendedTexture {
        abstract setFilterSave(arg0: boolean, arg1: boolean): void;
        abstract restoreLastFilter(): void;
    }
    type ExtendedTexture_ = ExtendedTexture;
    class SchematicannonBlockEntity extends Internal.SmartBlockEntity implements Internal.CustomRenderBoundingBoxBlockEntity, Internal.MenuProvider {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getDisplayName(): net.minecraft.network.chat.Component;
        finishedPrinting(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        findInventories(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        createMenu(id: number, inv: Internal.Inventory_, player: Internal.Player_): Internal.AbstractContainerMenu;
        config(): Internal.CSchematics;
        shouldCloseCurrentScreen(): boolean;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        playFiringSound(): void;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getShotsPerGunpowder(): number;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        updateChecklist(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        static stripBeltIfNotLast(blockState: Internal.BlockState_): Internal.BlockState;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get displayName(): net.minecraft.network.chat.Component
        get shotsPerGunpowder(): number
        get infiniteBoundingBox(): Internal.AABB
        replaceMode: number;
        checklist: Internal.MaterialChecklist;
        defaultYaw: number;
        missingItem: Internal.ItemStack;
        replaceBlockEntities: boolean;
        bookPrintingProgress: number;
        dontUpdateChecklist: boolean;
        positionNotLoaded: boolean;
        blocksToPlace: number;
        firstRenderTick: boolean;
        sendUpdate: boolean;
        printer: Internal.SchematicPrinter;
        static readonly MAX_ANCHOR_DISTANCE: 256;
        previousTarget: BlockPos;
        static readonly NEIGHBOUR_CHECKING: 100;
        remainingFuel: number;
        flyingBlocks: Internal.List<Internal.LaunchedItem>;
        state: Internal.SchematicannonBlockEntity$State;
        statusMsg: string;
        hasCreativeCrate: boolean;
        inventory: Internal.SchematicannonInventory;
        skipMissing: boolean;
        schematicProgress: number;
        neighbourCheckCooldown: number;
        blocksPlaced: number;
    }
    type SchematicannonBlockEntity_ = SchematicannonBlockEntity;
    class MelterBlock extends Internal.TinyMultiblockControllerBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(pLevel: Internal.Level_, pState: Internal.BlockState_, check: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type MelterBlock_ = MelterBlock;
    interface IdentifiableResourceReloadListener extends Internal.PreparableReloadListener {
        getFabricDependencies(): Internal.Collection<ResourceLocation>;
        getName(): string;
        abstract getFabricId(): ResourceLocation;
        abstract reload(arg0: Internal.PreparableReloadListener$PreparationBarrier_, arg1: Internal.ResourceManager_, arg2: Internal.ProfilerFiller_, arg3: Internal.ProfilerFiller_, arg4: Internal.Executor_, arg5: Internal.Executor_): Internal.CompletableFuture<void>;
        get fabricDependencies(): Internal.Collection<ResourceLocation>
        get name(): string
        get fabricId(): ResourceLocation
    }
    type IdentifiableResourceReloadListener_ = IdentifiableResourceReloadListener;
    class ArrowFireEnchantment extends Internal.Enchantment {
        constructor($$0: Internal.Enchantment$Rarity_, ...$$1: Internal.EquipmentSlot_[])
    }
    type ArrowFireEnchantment_ = ArrowFireEnchantment;
    class SimpleBlockConfiguration extends Internal.Record implements Internal.FeatureConfiguration {
        constructor($$0: Internal.BlockStateProvider_)
        toPlace(): Internal.BlockStateProvider;
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.SimpleBlockConfiguration>;
    }
    type SimpleBlockConfiguration_ = SimpleBlockConfiguration;
    class WorldgenRandom$Algorithm extends Internal.Enum<Internal.WorldgenRandom$Algorithm> {
        newInstance($$0: number): Internal.RandomSource;
        static values(): Internal.WorldgenRandom$Algorithm[];
        static valueOf($$0: string): Internal.WorldgenRandom$Algorithm;
        static readonly XOROSHIRO: Internal.WorldgenRandom$Algorithm;
        static readonly LEGACY: Internal.WorldgenRandom$Algorithm;
    }
    type WorldgenRandom$Algorithm_ = "legacy" | "xoroshiro" | WorldgenRandom$Algorithm;
    class BlockExInscriber extends Internal.BlockBaseGui<Internal.TileExInscriber> implements Internal.SimpleWaterloggedBlock {
        constructor()
        openGui(tile: Internal.TileExInscriber_, p: Internal.Player_): void;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type BlockExInscriber_ = BlockExInscriber;
    interface CharacterIterator extends Internal.Cloneable {
        abstract clone(): any;
        abstract first(): string;
        abstract previous(): string;
        abstract getBeginIndex(): number;
        abstract getIndex(): number;
        abstract setIndex(arg0: number): string;
        abstract next(): string;
        abstract current(): string;
        abstract last(): string;
        abstract getEndIndex(): number;
        get beginIndex(): number
        get index(): number
        set index(arg0: number)
        get endIndex(): number
        readonly DONE: "￿";
    }
    type CharacterIterator_ = CharacterIterator;
    interface ModelPartData {
        from(child: Internal.ModelPart_): this;
        abstract isHidden(): boolean;
        abstract getChildren(): Internal.ModelPart[];
        abstract getCuboids(): Internal.ModelCuboid[];
        abstract isVisible(): boolean;
        get hidden(): boolean
        get children(): Internal.ModelPart[]
        get cuboids(): Internal.ModelCuboid[]
        get visible(): boolean
    }
    type ModelPartData_ = ModelPartData;
    interface IBasicCellItem extends Internal.ICellWorkbenchItem {
        abstract getIdleDrain(): number;
        getConfigInventory(is: Internal.ItemStack_): Internal.ConfigInventory;
        abstract getBytesPerType(arg0: Internal.ItemStack_): number;
        abstract asItem(): Internal.Item;
        getCellTooltipImage(is: Internal.ItemStack_): Internal.Optional<Internal.TooltipComponent>;
        isBlackListed(cellItem: Internal.ItemStack_, requestedAddition: Internal.AEKey_): boolean;
        isStorageCell(i: Internal.ItemStack_): boolean;
        abstract setFuzzyMode(arg0: Internal.ItemStack_, arg1: Internal.FuzzyMode_): void;
        abstract getFuzzyMode(arg0: Internal.ItemStack_): Internal.FuzzyMode;
        abstract getTotalTypes(arg0: Internal.ItemStack_): number;
        abstract getBytes(arg0: Internal.ItemStack_): number;
        getUpgrades(stack: Internal.ItemStack_): Internal.IUpgradeInventory;
        emi(amount: number): Internal.EmiStack;
        isEditable(is: Internal.ItemStack_): boolean;
        storableInStorageCell(): boolean;
        emi(): Internal.EmiStack;
        addCellInformationToTooltip(is: Internal.ItemStack_, lines: Internal.List_<net.minecraft.network.chat.Component>): void;
        abstract getKeyType(): Internal.AEKeyType;
        get idleDrain(): number
        get keyType(): Internal.AEKeyType
    }
    type IBasicCellItem_ = IBasicCellItem;
    interface ICogWheel extends Internal.IRotate {
        isDedicatedCogWheel(): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        isDedicatedCogWheel(block: Internal.Block_): boolean;
        isLargeCogItem(test: Internal.ItemStack_): boolean;
        isSmallCog(block: Internal.Block_): boolean;
        isSmallCog(): boolean;
        playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        abstract getRotationAxis(arg0: Internal.BlockState_): Internal.Direction$Axis;
        isSmallCogItem(test: Internal.ItemStack_): boolean;
        showCapacityWithAnnotation(): boolean;
        hideStressImpact(): boolean;
        isDedicatedCogItem(test: Internal.ItemStack_): boolean;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        abstract hasShaftTowards(arg0: Internal.LevelReader_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Direction_): boolean;
        isSmallCog(state: Internal.BlockState_): boolean;
        isLargeCog(block: Internal.Block_): boolean;
        isLargeCog(): boolean;
        playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        isLargeCog(state: Internal.BlockState_): boolean;
        get dedicatedCogWheel(): boolean
        get smallCog(): boolean
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get largeCog(): boolean
    }
    type ICogWheel_ = ICogWheel;
    class GuideItem extends Internal.AEBaseItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type GuideItem_ = GuideItem;
    interface PrivilegedExceptionAction <T> {
        abstract run(): T;
        (): T;
    }
    type PrivilegedExceptionAction_<T> = PrivilegedExceptionAction<T>;
    class KeyCounter implements Internal.Iterable<Internal.Object2LongMap$Entry<Internal.AEKey>> {
        constructor()
        forEach(arg0: Internal.Consumer_<Internal.Object2LongMap$Entry<Internal.AEKey>>): void;
        getFirstKey<T extends Internal.AEKey>(keyClass: T): T;
        removeEmptySubmaps(): void;
        getFirstEntry(): Internal.Object2LongMap$Entry<Internal.AEKey>;
        getFirstEntry<T extends Internal.AEKey>(keyClass: T): Internal.Object2LongMap$Entry<Internal.AEKey>;
        isEmpty(): boolean;
        spliterator(): Internal.Spliterator<Internal.Object2LongMap$Entry<Internal.AEKey>>;
        remove(key: Internal.AEKey_, amount: number): void;
        removeAll(other: Internal.KeyCounter_): void;
        keySet(): Internal.Set<Internal.AEKey>;
        size(): number;
        addAll(other: Internal.KeyCounter_): void;
        iterator(): Internal.Iterator<Internal.Object2LongMap$Entry<Internal.AEKey>>;
        clear(): void;
        getFirstKey(): Internal.AEKey;
        set(key: Internal.AEKey_, amount: number): void;
        get(key: Internal.AEKey_): number;
        reset(): void;
        add(key: Internal.AEKey_, amount: number): void;
        findFuzzy(key: Internal.AEKey_, fuzzy: Internal.FuzzyMode_): Internal.Collection<Internal.Object2LongMap$Entry<Internal.AEKey>>;
        removeZeros(): void;
        get firstEntry(): Internal.Object2LongMap$Entry<Internal.AEKey>
        get empty(): boolean
        get firstKey(): Internal.AEKey
    }
    type KeyCounter_ = KeyCounter;
    class WouldSurvivePredicate implements net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate {
        static hasSturdyFace($$0: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        and(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag($$0: Vec3i_, $$1: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static noFluid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        negate(): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        test($$0: Internal.WorldGenLevel_, $$1: BlockPos_): boolean;
        static solid($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static insideWorld($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        or(arg0: Internal.BiPredicate_<Internal.WorldGenLevel, BlockPos>): Internal.BiPredicate<Internal.WorldGenLevel, BlockPos>;
        static matchesTag($$0: Internal.TagKey_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static solid(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static alwaysTrue(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Vec3i_, ...$$1: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        type(): Internal.BlockPredicateType<any>;
        static matchesBlocks($$0: Vec3i_, $$1: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable(): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static wouldSurvive($$0: Internal.BlockState_, $$1: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids($$0: Vec3i_, $$1: Internal.List_<Internal.Fluid>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static not($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids($$0: Vec3i_, ...$$1: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf($$0: Internal.List_<net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static allOf($$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_, $$1: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static anyOf(...$$0: net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static replaceable($$0: Vec3i_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static hasSturdyFace($$0: Vec3i_, $$1: Internal.Direction_): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        test(arg0: any, arg1: any): boolean;
        static matchesBlocks(...$$0: Internal.Block_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesBlocks($$0: Internal.List_<Internal.Block>): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static matchesFluids(...$$0: Internal.Fluid_[]): net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
        static readonly CODEC: Internal.Codec<Internal.WouldSurvivePredicate>;
    }
    type WouldSurvivePredicate_ = WouldSurvivePredicate;
    class CoralMushroomFeature extends Internal.CoralFeature {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type CoralMushroomFeature_ = CoralMushroomFeature;
    interface BogeyVisual {
        abstract hide(): void;
        abstract updateLight(arg0: number): void;
        abstract update(arg0: Internal.CompoundTag_, arg1: number, arg2: Internal.PoseStack_): void;
        abstract collectCrumblingInstances(arg0: Internal.Consumer_<Internal.Instance>): void;
        abstract "delete"(): void;
    }
    type BogeyVisual_ = BogeyVisual;
    class SpriteContents$AnimatedTexture implements Internal.SpriteContentsAnimationAccessor, Internal.SpriteContentsAnimatedTextureAccessor, me.jellysquid.mods.sodium.mixin.features.textures.animations.upload.SpriteContentsAnimationAccessor, Internal.TextureAtlasSprite$AnimatedTextureAccessor, Internal.AnimatedTextureDuck {
        getFrameY($$0: number): number;
        getFrameX($$0: number): number;
        railways$uploadWithVisibility(): void;
        uploadFrame($$0: number, $$1: number, $$2: number): void;
        uploadFirstFrame($$0: number, $$1: number): void;
        getFrames(): Internal.List<any>;
        port_lib$getFrameX(arg0: number): number;
        getField_28473(): number;
        port_lib$getFrameY(arg0: number): number;
        invokeUploadFrame(arg0: number, arg1: number, arg2: number): void;
        getUniqueFrames(): Internal.IntStream;
        getField_28472(): Internal.List<any>;
        createTicker(): Internal.SpriteTicker;
        get frames(): Internal.List<any>
        get field_28473(): number
        get uniqueFrames(): Internal.IntStream
        get field_28472(): Internal.List<any>
        readonly interpolateFrames: boolean;
        readonly frames: Internal.List<Internal.SpriteContents$FrameInfo>;
        readonly frameRowSize: number;
    }
    type SpriteContents$AnimatedTexture_ = SpriteContents$AnimatedTexture;
    interface ServerPacketListener extends Internal.PacketListener {
        abstract isAcceptingMessages(): boolean;
        abstract onDisconnect(arg0: net.minecraft.network.chat.Component_): void;
        shouldPropagateHandlingExceptions(): boolean;
        get acceptingMessages(): boolean
    }
    type ServerPacketListener_ = ServerPacketListener;
    class EnumArgument$Info$Template implements Internal.ArgumentTypeInfo$Template<Internal.EnumArgument<T>> {
        instantiate(arg0: Internal.CommandBuildContext_): Internal.ArgumentType<any>;
        instantiate(pStructure: Internal.CommandBuildContext_): Internal.EnumArgument<T>;
        type(): Internal.ArgumentTypeInfo<Internal.EnumArgument<T>, any>;
    }
    type EnumArgument$Info$Template_ = EnumArgument$Info$Template;
    class InfestedRotatedPillarBlock extends Internal.InfestedBlock {
        constructor($$0: Internal.Block_, $$1: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type InfestedRotatedPillarBlock_ = InfestedRotatedPillarBlock;
    class MoverType extends Internal.Enum<Internal.MoverType> {
        static valueOf($$0: string): Internal.MoverType;
        static values(): Internal.MoverType[];
        static readonly SHULKER: Internal.MoverType;
        static readonly PISTON: Internal.MoverType;
        static readonly SELF: Internal.MoverType;
        static readonly SHULKER_BOX: Internal.MoverType;
        static readonly PLAYER: Internal.MoverType;
    }
    type MoverType_ = "player" | MoverType | "shulker" | "shulker_box" | "self" | "piston";
    class GuiMessageTag$Icon extends Internal.Enum<Internal.GuiMessageTag$Icon> {
        draw($$0: Internal.GuiGraphics_, $$1: number, $$2: number): void;
        static valueOf($$0: string): Internal.GuiMessageTag$Icon;
        static values(): Internal.GuiMessageTag$Icon[];
        readonly width: number;
        static readonly CHAT_MODIFIED: Internal.GuiMessageTag$Icon;
        readonly height: number;
        readonly v: number;
        readonly u: number;
    }
    type GuiMessageTag$Icon_ = "chat_modified" | GuiMessageTag$Icon;
    interface StarEntity {
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        isTouchingUpsideDownFluid(): boolean;
        get touchingFluid(): Internal.FluidState
        get touchingUpsideDownFluid(): boolean
    }
    type StarEntity_ = StarEntity;
    class LayeredBlock extends Internal.RotatedPillarBlock {
        constructor(p_55926_: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type LayeredBlock_ = LayeredBlock;
    interface Int2ShortFunction extends it.unimi.dsi.fastutil.Function<number, number>, Internal.IntUnaryOperator {
        andThenFloat(arg0: Internal.Short2FloatFunction_): Internal.Int2FloatFunction;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: number): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        containsKey(arg0: number): boolean;
        composeReference<T>(arg0: Internal.Reference2IntFunction_<T>): Internal.Reference2ShortFunction<T>;
        andThen(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        andThenChar(arg0: Internal.Short2CharFunction_): Internal.Int2CharFunction;
        apply(arg0: number): number;
        remove(arg0: number): number;
        put(arg0: number, arg1: number): number;
        composeByte(arg0: Internal.Byte2IntFunction_): Internal.Byte2ShortFunction;
        abstract get(arg0: number): number;
        defaultReturnValue(): number;
        composeDouble(arg0: Internal.Double2IntFunction_): Internal.Double2ShortFunction;
        compose(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        applyAsInt(arg0: number): number;
        identity(): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        composeShort(arg0: Internal.Short2IntFunction_): Internal.Short2ShortFunction;
        andThenLong(arg0: Internal.Short2LongFunction_): Internal.Int2LongFunction;
        composeFloat(arg0: Internal.Float2IntFunction_): Internal.Float2ShortFunction;
        andThenByte(arg0: Internal.Short2ByteFunction_): Internal.Int2ByteFunction;
        andThenDouble(arg0: Internal.Short2DoubleFunction_): Internal.Int2DoubleFunction;
        composeLong(arg0: Internal.Long2IntFunction_): Internal.Long2ShortFunction;
        andThenObject<T>(arg0: Internal.Short2ObjectFunction_<T>): Internal.Int2ObjectFunction<T>;
        composeObject<T>(arg0: Internal.Object2IntFunction_<T>): Internal.Object2ShortFunction<T>;
        size(): number;
        composeChar(arg0: Internal.Char2IntFunction_): Internal.Char2ShortFunction;
        andThenInt(arg0: Internal.Short2IntFunction_): Internal.Int2IntFunction;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<number, T>;
        defaultReturnValue(arg0: number): void;
        clear(): void;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, number>;
        composeInt(arg0: Internal.Int2IntFunction_): this;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        andThenReference<T>(arg0: Internal.Short2ReferenceFunction_<T>): Internal.Int2ReferenceFunction<T>;
        getOrDefault(arg0: number, arg1: number): number;
        andThenShort(arg0: Internal.Short2ShortFunction_): this;
        (arg0: number): number;
    }
    type Int2ShortFunction_ = Int2ShortFunction;
    class ContraptionControlsBlockEntity extends Internal.SmartBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        tickAnimations(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        pressButton(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static sendStatus(player: Internal.Player_, filter: Internal.ItemStack_, enabled: boolean): void;
        updatePoweredState(): void;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get infiniteBoundingBox(): Internal.AABB
        disabled: boolean;
        button: Internal.LerpedFloat;
        indicator: Internal.LerpedFloat;
        powered: boolean;
        filtering: Internal.FilteringBehaviour;
    }
    type ContraptionControlsBlockEntity_ = ContraptionControlsBlockEntity;
}
